/*
  DAX Decompressor (by Dark_AleX)
*/


#include <windows.h>
#include <stdio.h>
#include <zlib.h>

typedef struct
{
	DWORD signature;
	DWORD decompSize;
	DWORD reserved[6];
} DAXHEADER;

#define DAX_SIGNATURE 0x00584144

BYTE combuf[9216], decbuf[8192];
DWORD *offsets = NULL; 
WORD *lengths = NULL;

char szIsoFileName[MAX_PATH] = "";
char szDaxFileName[MAX_PATH] = "";

HANDLE hIsoFile = INVALID_HANDLE_VALUE;
HANDLE hDaxFile = INVALID_HANDLE_VALUE;

void gotoxy(int xpos, int ypos)
{
	COORD scrn;   

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	scrn.X = xpos; 
	scrn.Y = ypos;

	SetConsoleCursorPosition(hOutput,scrn);
}

int getx()
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hOutput, &csbi);

	return csbi.dwCursorPosition.X;	
}

int gety()
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hOutput, &csbi);

	return csbi.dwCursorPosition.Y;	
}

void terminate(int code)
{
	if (hDaxFile != INVALID_HANDLE_VALUE)
		CloseHandle(hDaxFile);

	if (hIsoFile != INVALID_HANDLE_VALUE)
		CloseHandle(hIsoFile);

	if (offsets)
		GlobalFree(offsets);

	if (lengths)
		GlobalFree(lengths);

	printf("Press any key to continue.");
	getchar();
	exit(code);
}

int main()
{
	OPENFILENAME ofn;
	DAXHEADER header;
	DWORD nFrames, read, written, dsize;	
	int i, x, y;

	printf("DAX Decompressor (by Dark_AleX)\n\n");

    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn); 
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "DAX Files (*.dax)\0*.dax\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrFile = szDaxFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "dax";

    if(!GetOpenFileName(&ofn))
    {
        return -1; 
    }

	lstrcpy(szIsoFileName, szDaxFileName);

	for (i = 0; i < lstrlen(szIsoFileName); i++)
	{
		if (szIsoFileName[i] == '.')
		{
			break;
		}
	}

	lstrcpy(szIsoFileName+i, ".iso");
	
	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn); 
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "ISO Files (*.iso)\0*.iso\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrFile = szIsoFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    ofn.lpstrDefExt = "iso";

    if(!GetSaveFileName(&ofn))
    {
        return -1; 
    }

	hDaxFile = CreateFile(szDaxFileName, GENERIC_READ, FILE_SHARE_READ, NULL,
        OPEN_EXISTING, 0, NULL);

	if (hDaxFile == INVALID_HANDLE_VALUE)
	{
		printf("Cannot open input file %s\n", szDaxFileName);
		terminate(-1);
	}	

	hIsoFile = CreateFile(szIsoFileName, GENERIC_WRITE, 0, NULL,
        CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	if (hIsoFile == INVALID_HANDLE_VALUE)
	{
		printf("Cannot create output file %s\n", szIsoFileName);
		terminate(-1);
	}

	ReadFile(hDaxFile, &header, sizeof(header), &read, NULL);
	
	if (read != sizeof(header) || header.signature != DAX_SIGNATURE)
	{
		printf("Input is not a valid DAX file.\n");
		terminate(-1);
	}

	nFrames = header.decompSize / 8192;

	if ((header.decompSize % 8192) != 0)
		nFrames++;

	printf("N of frames: %d\n", nFrames);

	offsets = (DWORD *)GlobalAlloc(GPTR, nFrames * 4);
	lengths = (WORD *) GlobalAlloc(GPTR, nFrames * 2);

	ReadFile(hDaxFile, offsets, nFrames * 4, &read, NULL);
	if (read != nFrames * 4)
	{
		printf("Corrupted input file.\n");
		terminate(-1);
	}

	ReadFile(hDaxFile, lengths, nFrames * 2, &read, NULL);
	if (read != nFrames * 2)
	{
		printf("Corrupted input file.\n");
		terminate(-1);
	}	

	printf("Decompressing...  ");
	
	x = getx();
	y = gety();	
	
	for (i = 0; i < (int)nFrames; i++)
	{
		int res;

		SetFilePointer(hDaxFile, offsets[i], NULL, FILE_BEGIN);
		ReadFile(hDaxFile, combuf, lengths[i], &read, NULL);

		if (read != lengths[i])
		{
			printf("Input seems to be corrupted.\n");
			terminate(-1);
		}

		dsize = 8192;

		res = uncompress(decbuf, &dsize, combuf, lengths[i]);

		if (res != Z_OK)
		{
			printf("Error while decompressing (corrupt input?)\n");
			terminate(-1);
		}

		WriteFile(hIsoFile, decbuf, dsize, &written, NULL);

		if (written != dsize)
		{
			printf("I/O error writing to output file.\n");
			terminate(-1);
		}

		if ((i % 600) == 0)
		{
			if (((i * 100) / nFrames) != 100)
				gotoxy(x, y);
			else
				gotoxy(x-1, y);
			
			printf("%d%%", (i * 100) / nFrames);
		}
	}

	gotoxy(x-1, y);
	printf("100%%\n");
	
	printf("Finished.\n\n");	
	terminate(0);

	return 0;
}